using System;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
    public partial class TRACERYDB : DBUtils
    {
        #region Fields
        #endregion

        #region Constructors
        public TRACERYDB()
        {
        }
        #endregion

        #region Properties
        #endregion

        #region Methods
        public List<TRACER> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<TRACER> objReturn = null;
            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                     LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                     objReturn = dbContext.usp_TRACER_getitemsByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID).ToList();
                     LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }
            return objReturn;
        }
        #endregion
    }
}
